/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.impl;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.ScissorsScreen;
import me.shedaniel.math.Rectangle;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public final class ScissorsHandlerImpl
implements ScissorsHandler {
    @ApiStatus.Internal
    public static final ScissorsHandler INSTANCE = new ScissorsHandlerImpl();
    private final List<Rectangle> scissorsAreas = Lists.newArrayList();

    @Override
    public void clearScissors() {
        this.scissorsAreas.clear();
        this.applyScissors();
    }

    @Override
    public List<Rectangle> getScissorsAreas() {
        return Collections.unmodifiableList(this.scissorsAreas);
    }

    @Override
    public void scissor(Rectangle rectangle) {
        this.scissorsAreas.add(rectangle);
        this.applyScissors();
    }

    @Override
    public void removeLastScissor() {
        if (!this.scissorsAreas.isEmpty()) {
            this.scissorsAreas.remove(this.scissorsAreas.size() - 1);
        }
        this.applyScissors();
    }

    @Override
    public void applyScissors() {
        if (!this.scissorsAreas.isEmpty()) {
            Rectangle r = this.scissorsAreas.get(0).clone();
            for (int i = 1; i < this.scissorsAreas.size(); ++i) {
                Rectangle r1 = this.scissorsAreas.get(i);
                if (!r.intersects(r1)) {
                    if (Minecraft.func_71410_x().field_71462_r instanceof ScissorsScreen) {
                        this._applyScissor(((ScissorsScreen)Minecraft.func_71410_x().field_71462_r).handleScissor(new Rectangle()));
                    } else {
                        this._applyScissor(new Rectangle());
                    }
                    return;
                }
                r.setBounds(r.intersection(r1));
            }
            r.setBounds(Math.min(r.x, r.x + r.width), Math.min(r.y, r.y + r.height), Math.abs(r.width), Math.abs(r.height));
            if (Minecraft.func_71410_x().field_71462_r instanceof ScissorsScreen) {
                this._applyScissor(((ScissorsScreen)Minecraft.func_71410_x().field_71462_r).handleScissor(r));
            } else {
                this._applyScissor(r);
            }
        } else if (Minecraft.func_71410_x().field_71462_r instanceof ScissorsScreen) {
            this._applyScissor(((ScissorsScreen)Minecraft.func_71410_x().field_71462_r).handleScissor(null));
        } else {
            this._applyScissor(null);
        }
    }

    public void _applyScissor(Rectangle r) {
        if (r != null) {
            GL11.glEnable((int)3089);
            if (r.isEmpty()) {
                GL11.glScissor((int)0, (int)0, (int)0, (int)0);
            } else {
                MainWindow window = Minecraft.func_71410_x().func_228018_at_();
                double scaleFactor = window.func_198100_s();
                GL11.glScissor((int)((int)((double)r.x * scaleFactor)), (int)((int)((double)(window.func_198087_p() - r.height - r.y) * scaleFactor)), (int)((int)((double)r.width * scaleFactor)), (int)((int)((double)r.height * scaleFactor)));
            }
        } else {
            GL11.glDisable((int)3089);
        }
    }
}

